dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 5, 240, 250, "assets/images/table/ballroom_6", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 2, 4, 180, 410, "assets/images/table/ballroom", "assets/images/food/item_mark2", "R" );
LManager:AddNewTable( 3, 2, 400, 410, "assets/images/table/ballroom_2", "assets/images/food/item_mark1", "R" );

useFloAsServer = 0;
useWineTable = 0;
numMoodBoosts = 2;
numServers = 1;
maxCoupleHappiness = 200;

-- Group 1


guest = LManager.GenGuest(male02);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = table2;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(1, 3, 3000);


-- Group 2

guest = LManager.GenGuest(female04);
guest.matchType = female03;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(4, 4, 22000);

-- Group 3

guest = LManager.GenGuest(aunt);
guest.matchType = male02;
guest.percentRequestTissue = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = NOT_GUEST + female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = aunt;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(5, 7, 36000);

-- Group 4

guest = LManager.GenGuest(uncle);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(8, 8, 44000);

-- Group 5

guest = LManager.GenGuest(uncle);
guest.matchType = NOT_GUEST + male02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = table3;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(9, 10, 60000);


-- Group 6


guest = LManager.GenGuest(female04);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = NOT_GUEST + uncle;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + uncle;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(11, 13, 80000);

-- Group 7

guest = LManager.GenGuest(male02);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = male02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(14, 15, 100000);

-- Group 8

guest = LManager.GenGuest(female01);
guest.matchType = male04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(16, 17, 120000);



LManager:AdjustGuestTolerance(130);

LManager:AddQuinnEvent( "fx/fx_chef_table_fire.lua", 660, 155, 90000 );

LManager:SetLevelSetting ("speakerDelay", 120000); 
LManager:SetLevelSetting ("speakerChance", 40);



-- Set up the Level Settings
LManager:SetLevelNumber(2,8);
LManager:SetLevelScores(6800, 8800);
LManager:SetLevelTime(300000);
LManager:SetLevelSetting ("blaster", 1);

LManager:SetMusic("assets/audio/music/Big Band 4.ogg","assets/audio/music/Disco Dance 1.ogg","assets/audio/music/new_dance_4.ogg");
LManager:SetBackgroundImage("assets/images/bg_ballroom");
LManager:SetChairImage("assets/images/table/chair02");


-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );